package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.VpnConnectionArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SiteToSiteVpnAttachment(
    attachment: Option[zio.aws.networkmanager.model.Attachment] = None,
    vpnConnectionArn: Option[VpnConnectionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.SiteToSiteVpnAttachment = {
    import SiteToSiteVpnAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.SiteToSiteVpnAttachment
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        vpnConnectionArn.map(value =>
          VpnConnectionArn.unwrap(value): java.lang.String
        )
      )(_.vpnConnectionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.SiteToSiteVpnAttachment.ReadOnly =
    zio.aws.networkmanager.model.SiteToSiteVpnAttachment.wrap(buildAwsValue())
}
object SiteToSiteVpnAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.SiteToSiteVpnAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.SiteToSiteVpnAttachment =
      zio.aws.networkmanager.model.SiteToSiteVpnAttachment(
        attachment.map(value => value.asEditable),
        vpnConnectionArn.map(value => value)
      )
    def attachment: Option[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def vpnConnectionArn: Option[VpnConnectionArn]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
    def getVpnConnectionArn: ZIO[Any, AwsError, VpnConnectionArn] =
      AwsError.unwrapOptionField("vpnConnectionArn", vpnConnectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.SiteToSiteVpnAttachment
  ) extends zio.aws.networkmanager.model.SiteToSiteVpnAttachment.ReadOnly {
    override val attachment
        : Option[zio.aws.networkmanager.model.Attachment.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
    override val vpnConnectionArn: Option[VpnConnectionArn] = scala
      .Option(impl.vpnConnectionArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.VpnConnectionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.SiteToSiteVpnAttachment
  ): zio.aws.networkmanager.model.SiteToSiteVpnAttachment.ReadOnly =
    new Wrapper(impl)
}
