package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutCoreNetworkPolicyResponse(
    coreNetworkPolicy: Option[zio.aws.networkmanager.model.CoreNetworkPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyResponse = {
    import PutCoreNetworkPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyResponse
      .builder()
      .optionallyWith(coreNetworkPolicy.map(value => value.buildAwsValue()))(
        _.coreNetworkPolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly =
    zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse
      .wrap(buildAwsValue())
}
object PutCoreNetworkPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse =
      zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse(
        coreNetworkPolicy.map(value => value.asEditable)
      )
    def coreNetworkPolicy
        : Option[zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly]
    def getCoreNetworkPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("coreNetworkPolicy", coreNetworkPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyResponse
  ) extends zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly {
    override val coreNetworkPolicy
        : Option[zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly] =
      scala
        .Option(impl.coreNetworkPolicy())
        .map(value =>
          zio.aws.networkmanager.model.CoreNetworkPolicy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.PutCoreNetworkPolicyResponse
  ): zio.aws.networkmanager.model.PutCoreNetworkPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
