package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConnectAttachment(
    attachment: Option[zio.aws.networkmanager.model.Attachment] = None,
    transportAttachmentId: Option[AttachmentId] = None,
    options: Option[zio.aws.networkmanager.model.ConnectAttachmentOptions] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectAttachment = {
    import ConnectAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        transportAttachmentId.map(value =>
          AttachmentId.unwrap(value): java.lang.String
        )
      )(_.transportAttachmentId)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ConnectAttachment.ReadOnly =
    zio.aws.networkmanager.model.ConnectAttachment.wrap(buildAwsValue())
}
object ConnectAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectAttachment =
      zio.aws.networkmanager.model.ConnectAttachment(
        attachment.map(value => value.asEditable),
        transportAttachmentId.map(value => value),
        options.map(value => value.asEditable)
      )
    def attachment: Option[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def transportAttachmentId: Option[AttachmentId]
    def options
        : Option[zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
    def getTransportAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("transportAttachmentId", transportAttachmentId)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
  ) extends zio.aws.networkmanager.model.ConnectAttachment.ReadOnly {
    override val attachment
        : Option[zio.aws.networkmanager.model.Attachment.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
    override val transportAttachmentId: Option[AttachmentId] = scala
      .Option(impl.transportAttachmentId())
      .map(value => zio.aws.networkmanager.model.primitives.AttachmentId(value))
    override val options: Option[
      zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.networkmanager.model.ConnectAttachmentOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectAttachment
  ): zio.aws.networkmanager.model.ConnectAttachment.ReadOnly = new Wrapper(impl)
}
