package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{DateTime, ResourceArn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetNetworkRoutesResponse(
    routeTableArn: Option[ResourceArn] = None,
    coreNetworkSegmentEdge: Option[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
    ] = None,
    routeTableType: Option[zio.aws.networkmanager.model.RouteTableType] = None,
    routeTableTimestamp: Option[DateTime] = None,
    networkRoutes: Option[Iterable[zio.aws.networkmanager.model.NetworkRoute]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse = {
    import GetNetworkRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
      .builder()
      .optionallyWith(
        routeTableArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.routeTableArn)
      .optionallyWith(
        coreNetworkSegmentEdge.map(value => value.buildAwsValue())
      )(_.coreNetworkSegmentEdge)
      .optionallyWith(routeTableType.map(value => value.unwrap))(
        _.routeTableType
      )
      .optionallyWith(
        routeTableTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.routeTableTimestamp)
      .optionallyWith(
        networkRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkRoutes)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkRoutesResponse.wrap(buildAwsValue())
}
object GetNetworkRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetNetworkRoutesResponse =
      zio.aws.networkmanager.model.GetNetworkRoutesResponse(
        routeTableArn.map(value => value),
        coreNetworkSegmentEdge.map(value => value.asEditable),
        routeTableType.map(value => value),
        routeTableTimestamp.map(value => value),
        networkRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def routeTableArn: Option[ResourceArn]
    def coreNetworkSegmentEdge: Option[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ]
    def routeTableType: Option[zio.aws.networkmanager.model.RouteTableType]
    def routeTableTimestamp: Option[DateTime]
    def networkRoutes
        : Option[List[zio.aws.networkmanager.model.NetworkRoute.ReadOnly]]
    def getRouteTableArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("routeTableArn", routeTableArn)
    def getCoreNetworkSegmentEdge: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "coreNetworkSegmentEdge",
      coreNetworkSegmentEdge
    )
    def getRouteTableType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.RouteTableType] =
      AwsError.unwrapOptionField("routeTableType", routeTableType)
    def getRouteTableTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("routeTableTimestamp", routeTableTimestamp)
    def getNetworkRoutes: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.NetworkRoute.ReadOnly
    ]] = AwsError.unwrapOptionField("networkRoutes", networkRoutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
  ) extends zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly {
    override val routeTableArn: Option[ResourceArn] = scala
      .Option(impl.routeTableArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val coreNetworkSegmentEdge: Option[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ] = scala
      .Option(impl.coreNetworkSegmentEdge())
      .map(value =>
        zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
          .wrap(value)
      )
    override val routeTableType
        : Option[zio.aws.networkmanager.model.RouteTableType] = scala
      .Option(impl.routeTableType())
      .map(value => zio.aws.networkmanager.model.RouteTableType.wrap(value))
    override val routeTableTimestamp: Option[DateTime] = scala
      .Option(impl.routeTableTimestamp())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val networkRoutes
        : Option[List[zio.aws.networkmanager.model.NetworkRoute.ReadOnly]] =
      scala
        .Option(impl.networkRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.NetworkRoute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkRoutesResponse
  ): zio.aws.networkmanager.model.GetNetworkRoutesResponse.ReadOnly =
    new Wrapper(impl)
}
