package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetNetworkResourceCountsRequest(
    globalNetworkId: GlobalNetworkId,
    resourceType: Option[ConstrainedString] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest = {
    import GetNetworkResourceCountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkResourceCountsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkResourceCountsRequest
      .wrap(buildAwsValue())
}
object GetNetworkResourceCountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetNetworkResourceCountsRequest =
      zio.aws.networkmanager.model.GetNetworkResourceCountsRequest(
        globalNetworkId,
        resourceType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def resourceType: Option[ConstrainedString]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest
  ) extends zio.aws.networkmanager.model.GetNetworkResourceCountsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val resourceType: Option[ConstrainedString] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsRequest
  ): zio.aws.networkmanager.model.GetNetworkResourceCountsRequest.ReadOnly =
    new Wrapper(impl)
}
