package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConstrainedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkRoute(
    destinationCidrBlock: Option[ConstrainedString] = None,
    destinations: Option[
      Iterable[zio.aws.networkmanager.model.NetworkRouteDestination]
    ] = None,
    prefixListId: Option[ConstrainedString] = None,
    state: Option[zio.aws.networkmanager.model.RouteState] = None,
    `type`: Option[zio.aws.networkmanager.model.RouteType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkRoute = {
    import NetworkRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        prefixListId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkRoute.ReadOnly =
    zio.aws.networkmanager.model.NetworkRoute.wrap(buildAwsValue())
}
object NetworkRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkRoute =
      zio.aws.networkmanager.model.NetworkRoute(
        destinationCidrBlock.map(value => value),
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixListId.map(value => value),
        state.map(value => value),
        `type`.map(value => value)
      )
    def destinationCidrBlock: Option[ConstrainedString]
    def destinations: Option[
      List[zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly]
    ]
    def prefixListId: Option[ConstrainedString]
    def state: Option[zio.aws.networkmanager.model.RouteState]
    def `type`: Option[zio.aws.networkmanager.model.RouteType]
    def getDestinationCidrBlock: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getPrefixListId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getState: ZIO[Any, AwsError, zio.aws.networkmanager.model.RouteState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.networkmanager.model.RouteType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkRoute
  ) extends zio.aws.networkmanager.model.NetworkRoute.ReadOnly {
    override val destinationCidrBlock: Option[ConstrainedString] = scala
      .Option(impl.destinationCidrBlock())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val destinations: Option[
      List[zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly]
    ] = scala
      .Option(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.NetworkRouteDestination.wrap(item)
        }.toList
      )
    override val prefixListId: Option[ConstrainedString] = scala
      .Option(impl.prefixListId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val state: Option[zio.aws.networkmanager.model.RouteState] = scala
      .Option(impl.state())
      .map(value => zio.aws.networkmanager.model.RouteState.wrap(value))
    override val `type`: Option[zio.aws.networkmanager.model.RouteType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.networkmanager.model.RouteType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkRoute
  ): zio.aws.networkmanager.model.NetworkRoute.ReadOnly = new Wrapper(impl)
}
