package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetConnectionsResponse(
    connections: Option[Iterable[zio.aws.networkmanager.model.Connection]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse = {
    import GetConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetConnectionsResponse.wrap(buildAwsValue())
}
object GetConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetConnectionsResponse =
      zio.aws.networkmanager.model.GetConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connections
        : Option[List[zio.aws.networkmanager.model.Connection.ReadOnly]]
    def nextToken: Option[NextToken]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse
  ) extends zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly {
    override val connections
        : Option[List[zio.aws.networkmanager.model.Connection.ReadOnly]] = scala
      .Option(impl.connections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.Connection.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectionsResponse
  ): zio.aws.networkmanager.model.GetConnectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
