package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.IPAddress
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConnectPeerBgpConfiguration(
    coreNetworkAsn: Option[Long] = None,
    peerAsn: Option[Long] = None,
    coreNetworkAddress: Option[IPAddress] = None,
    peerAddress: Option[IPAddress] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration = {
    import ConnectPeerBgpConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
      .builder()
      .optionallyWith(coreNetworkAsn.map(value => value: java.lang.Long))(
        _.coreNetworkAsn
      )
      .optionallyWith(peerAsn.map(value => value: java.lang.Long))(_.peerAsn)
      .optionallyWith(
        coreNetworkAddress.map(value =>
          IPAddress.unwrap(value): java.lang.String
        )
      )(_.coreNetworkAddress)
      .optionallyWith(
        peerAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.peerAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly =
    zio.aws.networkmanager.model.ConnectPeerBgpConfiguration
      .wrap(buildAwsValue())
}
object ConnectPeerBgpConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectPeerBgpConfiguration =
      zio.aws.networkmanager.model.ConnectPeerBgpConfiguration(
        coreNetworkAsn.map(value => value),
        peerAsn.map(value => value),
        coreNetworkAddress.map(value => value),
        peerAddress.map(value => value)
      )
    def coreNetworkAsn: Option[Long]
    def peerAsn: Option[Long]
    def coreNetworkAddress: Option[IPAddress]
    def peerAddress: Option[IPAddress]
    def getCoreNetworkAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("coreNetworkAsn", coreNetworkAsn)
    def getPeerAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("peerAsn", peerAsn)
    def getCoreNetworkAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("coreNetworkAddress", coreNetworkAddress)
    def getPeerAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("peerAddress", peerAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
  ) extends zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly {
    override val coreNetworkAsn: Option[Long] =
      scala.Option(impl.coreNetworkAsn()).map(value => value: Long)
    override val peerAsn: Option[Long] =
      scala.Option(impl.peerAsn()).map(value => value: Long)
    override val coreNetworkAddress: Option[IPAddress] = scala
      .Option(impl.coreNetworkAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
    override val peerAddress: Option[IPAddress] = scala
      .Option(impl.peerAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerBgpConfiguration
  ): zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly =
    new Wrapper(impl)
}
