package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayRegistrationsResponse(
    transitGatewayRegistrations: Option[
      Iterable[zio.aws.networkmanager.model.TransitGatewayRegistration]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse = {
    import GetTransitGatewayRegistrationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse
      .builder()
      .optionallyWith(
        transitGatewayRegistrations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayRegistrations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayRegistrationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse =
      zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse(
        transitGatewayRegistrations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayRegistrations: Option[
      List[zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getTransitGatewayRegistrations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayRegistrations",
      transitGatewayRegistrations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse
  ) extends zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly {
    override val transitGatewayRegistrations: Option[
      List[zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly]
    ] = scala
      .Option(impl.transitGatewayRegistrations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.TransitGatewayRegistration.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse
  ): zio.aws.networkmanager.model.GetTransitGatewayRegistrationsResponse.ReadOnly =
    new Wrapper(impl)
}
