package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterTransitGatewayResponse(
    transitGatewayRegistration: Option[
      zio.aws.networkmanager.model.TransitGatewayRegistration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse = {
    import RegisterTransitGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
      .builder()
      .optionallyWith(
        transitGatewayRegistration.map(value => value.buildAwsValue())
      )(_.transitGatewayRegistration)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly =
    zio.aws.networkmanager.model.RegisterTransitGatewayResponse
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.RegisterTransitGatewayResponse =
      zio.aws.networkmanager.model.RegisterTransitGatewayResponse(
        transitGatewayRegistration.map(value => value.asEditable)
      )
    def transitGatewayRegistration: Option[
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ]
    def getTransitGatewayRegistration: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRegistration",
      transitGatewayRegistration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
  ) extends zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly {
    override val transitGatewayRegistration: Option[
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ] = scala
      .Option(impl.transitGatewayRegistration())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayRegistration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RegisterTransitGatewayResponse
  ): zio.aws.networkmanager.model.RegisterTransitGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
