package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{ConstrainedString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProposedSegmentChange(
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None,
    attachmentPolicyRuleNumber: Option[Integer] = None,
    segmentName: Option[ConstrainedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ProposedSegmentChange = {
    import ProposedSegmentChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ProposedSegmentChange
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        attachmentPolicyRuleNumber.map(value => value: java.lang.Integer)
      )(_.attachmentPolicyRuleNumber)
      .optionallyWith(
        segmentName.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly =
    zio.aws.networkmanager.model.ProposedSegmentChange.wrap(buildAwsValue())
}
object ProposedSegmentChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ProposedSegmentChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ProposedSegmentChange =
      zio.aws.networkmanager.model.ProposedSegmentChange(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachmentPolicyRuleNumber.map(value => value),
        segmentName.map(value => value)
      )
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def attachmentPolicyRuleNumber: Option[Integer]
    def segmentName: Option[ConstrainedString]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAttachmentPolicyRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "attachmentPolicyRuleNumber",
        attachmentPolicyRuleNumber
      )
    def getSegmentName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ProposedSegmentChange
  ) extends zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly {
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val attachmentPolicyRuleNumber: Option[Integer] = scala
      .Option(impl.attachmentPolicyRuleNumber())
      .map(value => value: Integer)
    override val segmentName: Option[ConstrainedString] = scala
      .Option(impl.segmentName())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ProposedSegmentChange
  ): zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly = new Wrapper(
    impl
  )
}
