package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetNetworkResourceCountsResponse(
    networkResourceCounts: Option[
      Iterable[zio.aws.networkmanager.model.NetworkResourceCount]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse = {
    import GetNetworkResourceCountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse
      .builder()
      .optionallyWith(
        networkResourceCounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkResourceCounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkResourceCountsResponse
      .wrap(buildAwsValue())
}
object GetNetworkResourceCountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetNetworkResourceCountsResponse =
      zio.aws.networkmanager.model.GetNetworkResourceCountsResponse(
        networkResourceCounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkResourceCounts: Option[
      List[zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getNetworkResourceCounts: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly
    ]] =
      AwsError.unwrapOptionField("networkResourceCounts", networkResourceCounts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse
  ) extends zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly {
    override val networkResourceCounts: Option[
      List[zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly]
    ] = scala
      .Option(impl.networkResourceCounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.NetworkResourceCount.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkResourceCountsResponse
  ): zio.aws.networkmanager.model.GetNetworkResourceCountsResponse.ReadOnly =
    new Wrapper(impl)
}
