package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCoreNetworkChangeSetResponse(
    coreNetworkChanges: Option[
      Iterable[zio.aws.networkmanager.model.CoreNetworkChange]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse = {
    import GetCoreNetworkChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
      .builder()
      .optionallyWith(
        coreNetworkChanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coreNetworkChanges)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly =
    zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse
      .wrap(buildAwsValue())
}
object GetCoreNetworkChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse =
      zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse(
        coreNetworkChanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coreNetworkChanges
        : Option[List[zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly]]
    def nextToken: Option[NextToken]
    def getCoreNetworkChanges: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly
    ]] = AwsError.unwrapOptionField("coreNetworkChanges", coreNetworkChanges)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
  ) extends zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly {
    override val coreNetworkChanges: Option[
      List[zio.aws.networkmanager.model.CoreNetworkChange.ReadOnly]
    ] = scala
      .Option(impl.coreNetworkChanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkChange.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse
  ): zio.aws.networkmanager.model.GetCoreNetworkChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
