package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  TransitGatewayConnectPeerArn,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateTransitGatewayConnectPeerRequest(
    globalNetworkId: GlobalNetworkId,
    transitGatewayConnectPeerArn: TransitGatewayConnectPeerArn,
    deviceId: DeviceId,
    linkId: Option[LinkId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest = {
    import AssociateTransitGatewayConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .transitGatewayConnectPeerArn(
        TransitGatewayConnectPeerArn.unwrap(
          transitGatewayConnectPeerArn
        ): java.lang.String
      )
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerRequest.ReadOnly =
    zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerRequest
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerRequest =
      zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerRequest(
        globalNetworkId,
        transitGatewayConnectPeerArn,
        deviceId,
        linkId.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def transitGatewayConnectPeerArn: TransitGatewayConnectPeerArn
    def deviceId: DeviceId
    def linkId: Option[LinkId]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getTransitGatewayConnectPeerArn
        : ZIO[Any, Nothing, TransitGatewayConnectPeerArn] =
      ZIO.succeed(transitGatewayConnectPeerArn)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest
  ) extends zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val transitGatewayConnectPeerArn: TransitGatewayConnectPeerArn =
      zio.aws.networkmanager.model.primitives
        .TransitGatewayConnectPeerArn(impl.transitGatewayConnectPeerArn())
    override val deviceId: DeviceId =
      zio.aws.networkmanager.model.primitives.DeviceId(impl.deviceId())
    override val linkId: Option[LinkId] = scala
      .Option(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest
  ): zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerRequest.ReadOnly =
    new Wrapper(impl)
}
