package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  LinkId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLinkRequest(
    globalNetworkId: GlobalNetworkId,
    linkId: LinkId,
    description: Option[ConstrainedString] = None,
    `type`: Option[ConstrainedString] = None,
    bandwidth: Option[zio.aws.networkmanager.model.Bandwidth] = None,
    provider: Option[ConstrainedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest = {
    import UpdateLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .linkId(LinkId.unwrap(linkId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(bandwidth.map(value => value.buildAwsValue()))(
        _.bandwidth
      )
      .optionallyWith(
        provider.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.provider)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.UpdateLinkRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateLinkRequest.wrap(buildAwsValue())
}
object UpdateLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateLinkRequest =
      zio.aws.networkmanager.model.UpdateLinkRequest(
        globalNetworkId,
        linkId,
        description.map(value => value),
        `type`.map(value => value),
        bandwidth.map(value => value.asEditable),
        provider.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def linkId: LinkId
    def description: Option[ConstrainedString]
    def `type`: Option[ConstrainedString]
    def bandwidth: Option[zio.aws.networkmanager.model.Bandwidth.ReadOnly]
    def provider: Option[ConstrainedString]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getLinkId: ZIO[Any, Nothing, LinkId] = ZIO.succeed(linkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getBandwidth
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Bandwidth.ReadOnly] =
      AwsError.unwrapOptionField("bandwidth", bandwidth)
    def getProvider: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("provider", provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest
  ) extends zio.aws.networkmanager.model.UpdateLinkRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val linkId: LinkId =
      zio.aws.networkmanager.model.primitives.LinkId(impl.linkId())
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val `type`: Option[ConstrainedString] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val bandwidth
        : Option[zio.aws.networkmanager.model.Bandwidth.ReadOnly] = scala
      .Option(impl.bandwidth())
      .map(value => zio.aws.networkmanager.model.Bandwidth.wrap(value))
    override val provider: Option[ConstrainedString] = scala
      .Option(impl.provider())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateLinkRequest
  ): zio.aws.networkmanager.model.UpdateLinkRequest.ReadOnly = new Wrapper(impl)
}
