package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ExternalRegionCode,
  ConstrainedString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CoreNetworkChangeValues(
    segmentName: Option[ConstrainedString] = None,
    edgeLocations: Option[Iterable[ExternalRegionCode]] = None,
    asn: Option[Long] = None,
    cidr: Option[ConstrainedString] = None,
    destinationIdentifier: Option[ConstrainedString] = None,
    insideCidrBlocks: Option[Iterable[ConstrainedString]] = None,
    sharedSegments: Option[Iterable[ConstrainedString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeValues = {
    import CoreNetworkChangeValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeValues
      .builder()
      .optionallyWith(
        segmentName.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .optionallyWith(
        edgeLocations.map(value =>
          value.map { item =>
            ExternalRegionCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.edgeLocations)
      .optionallyWith(asn.map(value => value: java.lang.Long))(_.asn)
      .optionallyWith(
        cidr.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.cidr)
      .optionallyWith(
        destinationIdentifier.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.destinationIdentifier)
      .optionallyWith(
        insideCidrBlocks.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insideCidrBlocks)
      .optionallyWith(
        sharedSegments.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sharedSegments)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkChangeValues.wrap(buildAwsValue())
}
object CoreNetworkChangeValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkChangeValues =
      zio.aws.networkmanager.model.CoreNetworkChangeValues(
        segmentName.map(value => value),
        edgeLocations.map(value => value),
        asn.map(value => value),
        cidr.map(value => value),
        destinationIdentifier.map(value => value),
        insideCidrBlocks.map(value => value),
        sharedSegments.map(value => value)
      )
    def segmentName: Option[ConstrainedString]
    def edgeLocations: Option[List[ExternalRegionCode]]
    def asn: Option[Long]
    def cidr: Option[ConstrainedString]
    def destinationIdentifier: Option[ConstrainedString]
    def insideCidrBlocks: Option[List[ConstrainedString]]
    def sharedSegments: Option[List[ConstrainedString]]
    def getSegmentName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
    def getEdgeLocations: ZIO[Any, AwsError, List[ExternalRegionCode]] =
      AwsError.unwrapOptionField("edgeLocations", edgeLocations)
    def getAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("asn", asn)
    def getCidr: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getDestinationIdentifier: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("destinationIdentifier", destinationIdentifier)
    def getInsideCidrBlocks: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("insideCidrBlocks", insideCidrBlocks)
    def getSharedSegments: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("sharedSegments", sharedSegments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeValues
  ) extends zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly {
    override val segmentName: Option[ConstrainedString] = scala
      .Option(impl.segmentName())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val edgeLocations: Option[List[ExternalRegionCode]] = scala
      .Option(impl.edgeLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(item)
        }.toList
      )
    override val asn: Option[Long] =
      scala.Option(impl.asn()).map(value => value: Long)
    override val cidr: Option[ConstrainedString] = scala
      .Option(impl.cidr())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val destinationIdentifier: Option[ConstrainedString] = scala
      .Option(impl.destinationIdentifier())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val insideCidrBlocks: Option[List[ConstrainedString]] = scala
      .Option(impl.insideCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(item)
        }.toList
      )
    override val sharedSegments: Option[List[ConstrainedString]] = scala
      .Option(impl.sharedSegments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeValues
  ): zio.aws.networkmanager.model.CoreNetworkChangeValues.ReadOnly =
    new Wrapper(impl)
}
