package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{ConnectPeerId, GlobalNetworkId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateConnectPeerRequest(
    globalNetworkId: GlobalNetworkId,
    connectPeerId: ConnectPeerId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest = {
    import DisassociateConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .connectPeerId(ConnectPeerId.unwrap(connectPeerId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DisassociateConnectPeerRequest.ReadOnly =
    zio.aws.networkmanager.model.DisassociateConnectPeerRequest
      .wrap(buildAwsValue())
}
object DisassociateConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DisassociateConnectPeerRequest =
      zio.aws.networkmanager.model
        .DisassociateConnectPeerRequest(globalNetworkId, connectPeerId)
    def globalNetworkId: GlobalNetworkId
    def connectPeerId: ConnectPeerId
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getConnectPeerId: ZIO[Any, Nothing, ConnectPeerId] =
      ZIO.succeed(connectPeerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest
  ) extends zio.aws.networkmanager.model.DisassociateConnectPeerRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val connectPeerId: ConnectPeerId =
      zio.aws.networkmanager.model.primitives
        .ConnectPeerId(impl.connectPeerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerRequest
  ): zio.aws.networkmanager.model.DisassociateConnectPeerRequest.ReadOnly =
    new Wrapper(impl)
}
