package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{Integer, CoreNetworkId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExecuteCoreNetworkChangeSetRequest(
    coreNetworkId: CoreNetworkId,
    policyVersionId: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest = {
    import ExecuteCoreNetworkChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .policyVersionId(policyVersionId: java.lang.Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetRequest.ReadOnly =
    zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetRequest
      .wrap(buildAwsValue())
}
object ExecuteCoreNetworkChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetRequest =
      zio.aws.networkmanager.model
        .ExecuteCoreNetworkChangeSetRequest(coreNetworkId, policyVersionId)
    def coreNetworkId: CoreNetworkId
    def policyVersionId: Integer
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getPolicyVersionId: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest
  ) extends zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val policyVersionId: Integer = impl.policyVersionId(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest
  ): zio.aws.networkmanager.model.ExecuteCoreNetworkChangeSetRequest.ReadOnly =
    new Wrapper(impl)
}
