package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateConnectAttachmentResponse(
    connectAttachment: Option[zio.aws.networkmanager.model.ConnectAttachment] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse = {
    import CreateConnectAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
      .builder()
      .optionallyWith(connectAttachment.map(value => value.buildAwsValue()))(
        _.connectAttachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateConnectAttachmentResponse
      .wrap(buildAwsValue())
}
object CreateConnectAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateConnectAttachmentResponse =
      zio.aws.networkmanager.model.CreateConnectAttachmentResponse(
        connectAttachment.map(value => value.asEditable)
      )
    def connectAttachment
        : Option[zio.aws.networkmanager.model.ConnectAttachment.ReadOnly]
    def getConnectAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("connectAttachment", connectAttachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
  ) extends zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly {
    override val connectAttachment
        : Option[zio.aws.networkmanager.model.ConnectAttachment.ReadOnly] =
      scala
        .Option(impl.connectAttachment())
        .map(value =>
          zio.aws.networkmanager.model.ConnectAttachment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectAttachmentResponse
  ): zio.aws.networkmanager.model.CreateConnectAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
