package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateGlobalNetworkResponse(
    globalNetwork: Option[zio.aws.networkmanager.model.GlobalNetwork] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse = {
    import UpdateGlobalNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse
      .builder()
      .optionallyWith(globalNetwork.map(value => value.buildAwsValue()))(
        _.globalNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateGlobalNetworkResponse
      .wrap(buildAwsValue())
}
object UpdateGlobalNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateGlobalNetworkResponse =
      zio.aws.networkmanager.model.UpdateGlobalNetworkResponse(
        globalNetwork.map(value => value.asEditable)
      )
    def globalNetwork
        : Option[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly]
    def getGlobalNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.GlobalNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("globalNetwork", globalNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse
  ) extends zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly {
    override val globalNetwork
        : Option[zio.aws.networkmanager.model.GlobalNetwork.ReadOnly] = scala
      .Option(impl.globalNetwork())
      .map(value => zio.aws.networkmanager.model.GlobalNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkResponse
  ): zio.aws.networkmanager.model.UpdateGlobalNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
