package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.TransitGatewayRouteTableArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RouteTableIdentifier(
    transitGatewayRouteTableArn: Option[TransitGatewayRouteTableArn] = None,
    coreNetworkSegmentEdge: Option[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteTableIdentifier = {
    import RouteTableIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteTableIdentifier
      .builder()
      .optionallyWith(
        transitGatewayRouteTableArn.map(value =>
          TransitGatewayRouteTableArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableArn)
      .optionallyWith(
        coreNetworkSegmentEdge.map(value => value.buildAwsValue())
      )(_.coreNetworkSegmentEdge)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.RouteTableIdentifier.ReadOnly =
    zio.aws.networkmanager.model.RouteTableIdentifier.wrap(buildAwsValue())
}
object RouteTableIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteTableIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteTableIdentifier =
      zio.aws.networkmanager.model.RouteTableIdentifier(
        transitGatewayRouteTableArn.map(value => value),
        coreNetworkSegmentEdge.map(value => value.asEditable)
      )
    def transitGatewayRouteTableArn: Option[TransitGatewayRouteTableArn]
    def coreNetworkSegmentEdge: Option[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ]
    def getTransitGatewayRouteTableArn
        : ZIO[Any, AwsError, TransitGatewayRouteTableArn] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableArn",
        transitGatewayRouteTableArn
      )
    def getCoreNetworkSegmentEdge: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "coreNetworkSegmentEdge",
      coreNetworkSegmentEdge
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteTableIdentifier
  ) extends zio.aws.networkmanager.model.RouteTableIdentifier.ReadOnly {
    override val transitGatewayRouteTableArn
        : Option[TransitGatewayRouteTableArn] = scala
      .Option(impl.transitGatewayRouteTableArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayRouteTableArn(value)
      )
    override val coreNetworkSegmentEdge: Option[
      zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier.ReadOnly
    ] = scala
      .Option(impl.coreNetworkSegmentEdge())
      .map(value =>
        zio.aws.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteTableIdentifier
  ): zio.aws.networkmanager.model.RouteTableIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
