package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{ConstrainedString, ResourceArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateNetworkResourceMetadataResponse(
    resourceArn: Option[ResourceArn] = None,
    metadata: Option[Map[ConstrainedString, ConstrainedString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataResponse = {
    import UpdateNetworkResourceMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (ConstrainedString
                .unwrap(key): java.lang.String) -> (ConstrainedString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse
      .wrap(buildAwsValue())
}
object UpdateNetworkResourceMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse =
      zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse(
        resourceArn.map(value => value),
        metadata.map(value => value)
      )
    def resourceArn: Option[ResourceArn]
    def metadata: Option[Map[ConstrainedString, ConstrainedString]]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getMetadata
        : ZIO[Any, AwsError, Map[ConstrainedString, ConstrainedString]] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataResponse
  ) extends zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly {
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val metadata: Option[Map[ConstrainedString, ConstrainedString]] =
      scala
        .Option(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.networkmanager.model.primitives.ConstrainedString(
                key
              ) -> zio.aws.networkmanager.model.primitives
                .ConstrainedString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateNetworkResourceMetadataResponse
  ): zio.aws.networkmanager.model.UpdateNetworkResourceMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
