package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLinkResponse(
    link: Option[zio.aws.networkmanager.model.Link] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse = {
    import UpdateLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse
      .builder()
      .optionallyWith(link.map(value => value.buildAwsValue()))(_.link)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateLinkResponse.wrap(buildAwsValue())
}
object UpdateLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateLinkResponse =
      zio.aws.networkmanager.model
        .UpdateLinkResponse(link.map(value => value.asEditable))
    def link: Option[zio.aws.networkmanager.model.Link.ReadOnly]
    def getLink
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Link.ReadOnly] =
      AwsError.unwrapOptionField("link", link)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse
  ) extends zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly {
    override val link: Option[zio.aws.networkmanager.model.Link.ReadOnly] =
      scala
        .Option(impl.link())
        .map(value => zio.aws.networkmanager.model.Link.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateLinkResponse
  ): zio.aws.networkmanager.model.UpdateLinkResponse.ReadOnly = new Wrapper(
    impl
  )
}
