package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAttachmentsResponse(
    attachments: Option[Iterable[zio.aws.networkmanager.model.Attachment]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse = {
    import ListAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly =
    zio.aws.networkmanager.model.ListAttachmentsResponse.wrap(buildAwsValue())
}
object ListAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListAttachmentsResponse =
      zio.aws.networkmanager.model.ListAttachmentsResponse(
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attachments
        : Option[List[zio.aws.networkmanager.model.Attachment.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.Attachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse
  ) extends zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly {
    override val attachments
        : Option[List[zio.aws.networkmanager.model.Attachment.ReadOnly]] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.Attachment.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListAttachmentsResponse
  ): zio.aws.networkmanager.model.ListAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
