package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  DateTime,
  AttachmentId,
  ExternalRegionCode,
  ConnectPeerId,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ConnectPeerSummary(
    coreNetworkId: Option[CoreNetworkId] = None,
    connectAttachmentId: Option[AttachmentId] = None,
    connectPeerId: Option[ConnectPeerId] = None,
    edgeLocation: Option[ExternalRegionCode] = None,
    connectPeerState: Option[zio.aws.networkmanager.model.ConnectPeerState] =
      None,
    createdAt: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary = {
    import ConnectPeerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        connectAttachmentId.map(value =>
          AttachmentId.unwrap(value): java.lang.String
        )
      )(_.connectAttachmentId)
      .optionallyWith(
        connectPeerId.map(value =>
          ConnectPeerId.unwrap(value): java.lang.String
        )
      )(_.connectPeerId)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(connectPeerState.map(value => value.unwrap))(
        _.connectPeerState
      )
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly =
    zio.aws.networkmanager.model.ConnectPeerSummary.wrap(buildAwsValue())
}
object ConnectPeerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectPeerSummary =
      zio.aws.networkmanager.model.ConnectPeerSummary(
        coreNetworkId.map(value => value),
        connectAttachmentId.map(value => value),
        connectPeerId.map(value => value),
        edgeLocation.map(value => value),
        connectPeerState.map(value => value),
        createdAt.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def coreNetworkId: Option[CoreNetworkId]
    def connectAttachmentId: Option[AttachmentId]
    def connectPeerId: Option[ConnectPeerId]
    def edgeLocation: Option[ExternalRegionCode]
    def connectPeerState: Option[zio.aws.networkmanager.model.ConnectPeerState]
    def createdAt: Option[DateTime]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getConnectAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("connectAttachmentId", connectAttachmentId)
    def getConnectPeerId: ZIO[Any, AwsError, ConnectPeerId] =
      AwsError.unwrapOptionField("connectPeerId", connectPeerId)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getConnectPeerState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ConnectPeerState] =
      AwsError.unwrapOptionField("connectPeerState", connectPeerState)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary
  ) extends zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly {
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val connectAttachmentId: Option[AttachmentId] = scala
      .Option(impl.connectAttachmentId())
      .map(value => zio.aws.networkmanager.model.primitives.AttachmentId(value))
    override val connectPeerId: Option[ConnectPeerId] = scala
      .Option(impl.connectPeerId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConnectPeerId(value)
      )
    override val edgeLocation: Option[ExternalRegionCode] = scala
      .Option(impl.edgeLocation())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val connectPeerState
        : Option[zio.aws.networkmanager.model.ConnectPeerState] = scala
      .Option(impl.connectPeerState())
      .map(value => zio.aws.networkmanager.model.ConnectPeerState.wrap(value))
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary
  ): zio.aws.networkmanager.model.ConnectPeerSummary.ReadOnly = new Wrapper(
    impl
  )
}
