package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{Integer, ConstrainedString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkResourceCount(
    resourceType: Option[ConstrainedString] = None,
    count: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount = {
    import NetworkResourceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly =
    zio.aws.networkmanager.model.NetworkResourceCount.wrap(buildAwsValue())
}
object NetworkResourceCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkResourceCount =
      zio.aws.networkmanager.model.NetworkResourceCount(
        resourceType.map(value => value),
        count.map(value => value)
      )
    def resourceType: Option[ConstrainedString]
    def count: Option[Integer]
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount
  ) extends zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly {
    override val resourceType: Option[ConstrainedString] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val count: Option[Integer] =
      scala.Option(impl.count()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResourceCount
  ): zio.aws.networkmanager.model.NetworkResourceCount.ReadOnly = new Wrapper(
    impl
  )
}
