package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLinksResponse(
    links: Option[Iterable[zio.aws.networkmanager.model.Link]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetLinksResponse = {
    import GetLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
      .builder()
      .optionallyWith(
        links.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.links)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetLinksResponse.ReadOnly =
    zio.aws.networkmanager.model.GetLinksResponse.wrap(buildAwsValue())
}
object GetLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetLinksResponse =
      zio.aws.networkmanager.model.GetLinksResponse(
        links.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def links: Option[List[zio.aws.networkmanager.model.Link.ReadOnly]]
    def nextToken: Option[NextToken]
    def getLinks
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Link.ReadOnly]] =
      AwsError.unwrapOptionField("links", links)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
  ) extends zio.aws.networkmanager.model.GetLinksResponse.ReadOnly {
    override val links
        : Option[List[zio.aws.networkmanager.model.Link.ReadOnly]] = scala
      .Option(impl.links())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.Link.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinksResponse
  ): zio.aws.networkmanager.model.GetLinksResponse.ReadOnly = new Wrapper(impl)
}
