package zio.aws.networkmanager
import zio.prelude.Subtype
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId,
  DeviceId,
  ConnectionId,
  LinkId,
  FilterName,
  TransitGatewayConnectPeerArn,
  ReasonContextValue,
  SiteId,
  ExternalRegionCode,
  SubnetArn,
  FilterValue,
  ConnectPeerId,
  TransitGatewayArn,
  ReasonContextKey,
  CustomerGatewayArn,
  TagKey
}
import java.time.Instant
import zio.aws.networkmanager.model.primitives.GlobalNetworkArn.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AWSAccountId extends Subtype[String]
    type AWSAccountId =
      zio.aws.networkmanager.model.primitives.AWSAccountId.Type
    object AttachmentId extends Subtype[String]
    type AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.networkmanager.model.primitives.ClientToken.Type
    object ConnectPeerId extends Subtype[String]
    type ConnectPeerId =
      zio.aws.networkmanager.model.primitives.ConnectPeerId.Type
    object ConnectionArn extends Subtype[String]
    type ConnectionArn =
      zio.aws.networkmanager.model.primitives.ConnectionArn.Type
    object ConnectionId extends Subtype[String]
    type ConnectionId =
      zio.aws.networkmanager.model.primitives.ConnectionId.Type
    object ConstrainedString extends Subtype[String]
    type ConstrainedString =
      zio.aws.networkmanager.model.primitives.ConstrainedString.Type
    object CoreNetworkArn extends Subtype[String]
    type CoreNetworkArn =
      zio.aws.networkmanager.model.primitives.CoreNetworkArn.Type
    object CoreNetworkId extends Subtype[String]
    type CoreNetworkId =
      zio.aws.networkmanager.model.primitives.CoreNetworkId.Type
    object CoreNetworkPolicyDocument extends Subtype[String]
    type CoreNetworkPolicyDocument =
      zio.aws.networkmanager.model.primitives.CoreNetworkPolicyDocument.Type
    object CustomerGatewayArn extends Subtype[String]
    type CustomerGatewayArn =
      zio.aws.networkmanager.model.primitives.CustomerGatewayArn.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.networkmanager.model.primitives.DateTime.Type
    object DeviceArn extends Subtype[String]
    type DeviceArn = zio.aws.networkmanager.model.primitives.DeviceArn.Type
    object DeviceId extends Subtype[String]
    type DeviceId = zio.aws.networkmanager.model.primitives.DeviceId.Type
    object ExternalRegionCode extends Subtype[String]
    type ExternalRegionCode =
      zio.aws.networkmanager.model.primitives.ExternalRegionCode.Type
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.networkmanager.model.primitives.FilterName.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.networkmanager.model.primitives.FilterValue.Type
    object GlobalNetworkArn extends Subtype[String]
    type GlobalNetworkArn =
      zio.aws.networkmanager.model.primitives.GlobalNetworkArn.Type
    object GlobalNetworkId extends Subtype[String]
    type GlobalNetworkId =
      zio.aws.networkmanager.model.primitives.GlobalNetworkId.Type
    object IPAddress extends Subtype[String]
    type IPAddress = zio.aws.networkmanager.model.primitives.IPAddress.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.networkmanager.model.primitives.Integer.Type
    object LinkArn extends Subtype[String]
    type LinkArn = zio.aws.networkmanager.model.primitives.LinkArn.Type
    object LinkId extends Subtype[String]
    type LinkId = zio.aws.networkmanager.model.primitives.LinkId.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.networkmanager.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.networkmanager.model.primitives.NextToken.Type
    object ReasonContextKey extends Subtype[String]
    type ReasonContextKey =
      zio.aws.networkmanager.model.primitives.ReasonContextKey.Type
    object ReasonContextValue extends Subtype[String]
    type ReasonContextValue =
      zio.aws.networkmanager.model.primitives.ReasonContextValue.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.networkmanager.model.primitives.ResourceArn.Type
    object ResourcePolicyDocument extends Subtype[String]
    type ResourcePolicyDocument =
      zio.aws.networkmanager.model.primitives.ResourcePolicyDocument.Type
    object ServerSideString extends Subtype[String]
    type ServerSideString =
      zio.aws.networkmanager.model.primitives.ServerSideString.Type
    object SiteArn extends Subtype[String]
    type SiteArn = zio.aws.networkmanager.model.primitives.SiteArn.Type
    object SiteId extends Subtype[String]
    type SiteId = zio.aws.networkmanager.model.primitives.SiteId.Type
    object SubnetArn extends Subtype[String]
    type SubnetArn = zio.aws.networkmanager.model.primitives.SubnetArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.networkmanager.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.networkmanager.model.primitives.TagValue.Type
    object TransitGatewayArn extends Subtype[String]
    type TransitGatewayArn =
      zio.aws.networkmanager.model.primitives.TransitGatewayArn.Type
    object TransitGatewayAttachmentArn extends Subtype[String]
    type TransitGatewayAttachmentArn =
      zio.aws.networkmanager.model.primitives.TransitGatewayAttachmentArn.Type
    object TransitGatewayAttachmentId extends Subtype[String]
    type TransitGatewayAttachmentId =
      zio.aws.networkmanager.model.primitives.TransitGatewayAttachmentId.Type
    object TransitGatewayConnectPeerArn extends Subtype[String]
    type TransitGatewayConnectPeerArn =
      zio.aws.networkmanager.model.primitives.TransitGatewayConnectPeerArn.Type
    object TransitGatewayRouteTableArn extends Subtype[String]
    type TransitGatewayRouteTableArn =
      zio.aws.networkmanager.model.primitives.TransitGatewayRouteTableArn.Type
    object VpcArn extends Subtype[String]
    type VpcArn = zio.aws.networkmanager.model.primitives.VpcArn.Type
    object VpnConnectionArn extends Subtype[String]
    type VpnConnectionArn =
      zio.aws.networkmanager.model.primitives.VpnConnectionArn.Type
  }
  type AttachmentList = List[zio.aws.networkmanager.model.Attachment]
  type ConnectPeerAssociationList =
    List[zio.aws.networkmanager.model.ConnectPeerAssociation]
  type ConnectPeerBgpConfigurationList =
    List[zio.aws.networkmanager.model.ConnectPeerBgpConfiguration]
  type ConnectPeerIdList = List[ConnectPeerId]
  type ConnectPeerSummaryList =
    List[zio.aws.networkmanager.model.ConnectPeerSummary]
  type ConnectionIdList = List[ConnectionId]
  type ConnectionList = List[zio.aws.networkmanager.model.Connection]
  type ConstrainedStringList = List[ConstrainedString]
  type CoreNetworkChangeList =
    List[zio.aws.networkmanager.model.CoreNetworkChange]
  type CoreNetworkEdgeList = List[zio.aws.networkmanager.model.CoreNetworkEdge]
  type CoreNetworkPolicyErrorList =
    List[zio.aws.networkmanager.model.CoreNetworkPolicyError]
  type CoreNetworkPolicyVersionList =
    List[zio.aws.networkmanager.model.CoreNetworkPolicyVersion]
  type CoreNetworkSegmentList =
    List[zio.aws.networkmanager.model.CoreNetworkSegment]
  type CoreNetworkSummaryList =
    List[zio.aws.networkmanager.model.CoreNetworkSummary]
  type CustomerGatewayArnList = List[CustomerGatewayArn]
  type CustomerGatewayAssociationList =
    List[zio.aws.networkmanager.model.CustomerGatewayAssociation]
  type DeviceIdList = List[DeviceId]
  type DeviceList = List[zio.aws.networkmanager.model.Device]
  type ExternalRegionCodeList = List[ExternalRegionCode]
  type FilterMap = Map[FilterName, Iterable[FilterValue]]
  type FilterValues = List[FilterValue]
  type GlobalNetworkIdList = List[GlobalNetworkId]
  type GlobalNetworkList = List[zio.aws.networkmanager.model.GlobalNetwork]
  type LinkAssociationList = List[zio.aws.networkmanager.model.LinkAssociation]
  type LinkIdList = List[LinkId]
  type LinkList = List[zio.aws.networkmanager.model.Link]
  type NetworkResourceCountList =
    List[zio.aws.networkmanager.model.NetworkResourceCount]
  type NetworkResourceList = List[zio.aws.networkmanager.model.NetworkResource]
  type NetworkResourceMetadataMap = Map[ConstrainedString, ConstrainedString]
  type NetworkRouteDestinationList =
    List[zio.aws.networkmanager.model.NetworkRouteDestination]
  type NetworkRouteList = List[zio.aws.networkmanager.model.NetworkRoute]
  type NetworkTelemetryList =
    List[zio.aws.networkmanager.model.NetworkTelemetry]
  type PathComponentList = List[zio.aws.networkmanager.model.PathComponent]
  type ReasonContextMap = Map[ReasonContextKey, ReasonContextValue]
  type RelationshipList = List[zio.aws.networkmanager.model.Relationship]
  type RouteStateList = List[zio.aws.networkmanager.model.RouteState]
  type RouteTypeList = List[zio.aws.networkmanager.model.RouteType]
  type SiteIdList = List[SiteId]
  type SiteList = List[zio.aws.networkmanager.model.Site]
  type SubnetArnList = List[SubnetArn]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.networkmanager.model.Tag]
  type TransitGatewayArnList = List[TransitGatewayArn]
  type TransitGatewayConnectPeerArnList = List[TransitGatewayConnectPeerArn]
  type TransitGatewayConnectPeerAssociationList =
    List[zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation]
  type TransitGatewayRegistrationList =
    List[zio.aws.networkmanager.model.TransitGatewayRegistration]
}
