package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  ExternalRegionCode,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAttachmentsRequest(
    coreNetworkId: Option[CoreNetworkId] = None,
    attachmentType: Option[zio.aws.networkmanager.model.AttachmentType] = None,
    edgeLocation: Option[ExternalRegionCode] = None,
    state: Option[zio.aws.networkmanager.model.AttachmentState] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest = {
    import ListAttachmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(attachmentType.map(value => value.unwrap))(
        _.attachmentType
      )
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ListAttachmentsRequest.ReadOnly =
    zio.aws.networkmanager.model.ListAttachmentsRequest.wrap(buildAwsValue())
}
object ListAttachmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListAttachmentsRequest =
      zio.aws.networkmanager.model.ListAttachmentsRequest(
        coreNetworkId.map(value => value),
        attachmentType.map(value => value),
        edgeLocation.map(value => value),
        state.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: Option[CoreNetworkId]
    def attachmentType: Option[zio.aws.networkmanager.model.AttachmentType]
    def edgeLocation: Option[ExternalRegionCode]
    def state: Option[zio.aws.networkmanager.model.AttachmentState]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getAttachmentType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentType] =
      AwsError.unwrapOptionField("attachmentType", attachmentType)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
  ) extends zio.aws.networkmanager.model.ListAttachmentsRequest.ReadOnly {
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val attachmentType
        : Option[zio.aws.networkmanager.model.AttachmentType] = scala
      .Option(impl.attachmentType())
      .map(value => zio.aws.networkmanager.model.AttachmentType.wrap(value))
    override val edgeLocation: Option[ExternalRegionCode] = scala
      .Option(impl.edgeLocation())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val state: Option[zio.aws.networkmanager.model.AttachmentState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.networkmanager.model.AttachmentState.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
  ): zio.aws.networkmanager.model.ListAttachmentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
