package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeGlobalNetworksRequest(
    globalNetworkIds: Option[Iterable[GlobalNetworkId]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest = {
    import DescribeGlobalNetworksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
      .builder()
      .optionallyWith(
        globalNetworkIds.map(value =>
          value.map { item =>
            GlobalNetworkId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.globalNetworkIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DescribeGlobalNetworksRequest.ReadOnly =
    zio.aws.networkmanager.model.DescribeGlobalNetworksRequest
      .wrap(buildAwsValue())
}
object DescribeGlobalNetworksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DescribeGlobalNetworksRequest =
      zio.aws.networkmanager.model.DescribeGlobalNetworksRequest(
        globalNetworkIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkIds: Option[List[GlobalNetworkId]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getGlobalNetworkIds: ZIO[Any, AwsError, List[GlobalNetworkId]] =
      AwsError.unwrapOptionField("globalNetworkIds", globalNetworkIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
  ) extends zio.aws.networkmanager.model.DescribeGlobalNetworksRequest.ReadOnly {
    override val globalNetworkIds: Option[List[GlobalNetworkId]] = scala
      .Option(impl.globalNetworkIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest
  ): zio.aws.networkmanager.model.DescribeGlobalNetworksRequest.ReadOnly =
    new Wrapper(impl)
}
