package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{DeviceId, GlobalNetworkId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDeviceRequest(
    globalNetworkId: GlobalNetworkId,
    deviceId: DeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest = {
    import DeleteDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeleteDeviceRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteDeviceRequest.wrap(buildAwsValue())
}
object DeleteDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteDeviceRequest =
      zio.aws.networkmanager.model
        .DeleteDeviceRequest(globalNetworkId, deviceId)
    def globalNetworkId: GlobalNetworkId
    def deviceId: DeviceId
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest
  ) extends zio.aws.networkmanager.model.DeleteDeviceRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val deviceId: DeviceId =
      zio.aws.networkmanager.model.primitives.DeviceId(impl.deviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteDeviceRequest
  ): zio.aws.networkmanager.model.DeleteDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
