package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConstrainedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayRegistrationStateReason(
    code: Option[zio.aws.networkmanager.model.TransitGatewayRegistrationState] =
      None,
    message: Option[ConstrainedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationStateReason = {
    import TransitGatewayRegistrationStateReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationStateReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason.ReadOnly =
    zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason
      .wrap(buildAwsValue())
}
object TransitGatewayRegistrationStateReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationStateReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason =
      zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code
        : Option[zio.aws.networkmanager.model.TransitGatewayRegistrationState]
    def message: Option[ConstrainedString]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayRegistrationState
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationStateReason
  ) extends zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason.ReadOnly {
    override val code
        : Option[zio.aws.networkmanager.model.TransitGatewayRegistrationState] =
      scala
        .Option(impl.code())
        .map(value =>
          zio.aws.networkmanager.model.TransitGatewayRegistrationState
            .wrap(value)
        )
    override val message: Option[ConstrainedString] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistrationStateReason
  ): zio.aws.networkmanager.model.TransitGatewayRegistrationStateReason.ReadOnly =
    new Wrapper(impl)
}
