package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  IPAddress,
  TransitGatewayArn,
  TransitGatewayAttachmentArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RouteAnalysisEndpointOptions(
    transitGatewayAttachmentArn: Option[TransitGatewayAttachmentArn] = None,
    transitGatewayArn: Option[TransitGatewayArn] = None,
    ipAddress: Option[IPAddress] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions = {
    import RouteAnalysisEndpointOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
      .builder()
      .optionallyWith(
        transitGatewayAttachmentArn.map(value =>
          TransitGatewayAttachmentArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentArn)
      .optionallyWith(
        transitGatewayArn.map(value =>
          TransitGatewayArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayArn)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisEndpointOptions
      .wrap(buildAwsValue())
}
object RouteAnalysisEndpointOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteAnalysisEndpointOptions =
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions(
        transitGatewayAttachmentArn.map(value => value),
        transitGatewayArn.map(value => value),
        ipAddress.map(value => value)
      )
    def transitGatewayAttachmentArn: Option[TransitGatewayAttachmentArn]
    def transitGatewayArn: Option[TransitGatewayArn]
    def ipAddress: Option[IPAddress]
    def getTransitGatewayAttachmentArn
        : ZIO[Any, AwsError, TransitGatewayAttachmentArn] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentArn",
        transitGatewayAttachmentArn
      )
    def getTransitGatewayArn: ZIO[Any, AwsError, TransitGatewayArn] =
      AwsError.unwrapOptionField("transitGatewayArn", transitGatewayArn)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
  ) extends zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly {
    override val transitGatewayAttachmentArn
        : Option[TransitGatewayAttachmentArn] = scala
      .Option(impl.transitGatewayAttachmentArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayAttachmentArn(value)
      )
    override val transitGatewayArn: Option[TransitGatewayArn] = scala
      .Option(impl.transitGatewayArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.TransitGatewayArn(value)
      )
    override val ipAddress: Option[IPAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions
  ): zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly =
    new Wrapper(impl)
}
