package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ExternalRegionCode,
  ConstrainedString,
  TransitGatewayAttachmentId,
  AttachmentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkRouteDestination(
    coreNetworkAttachmentId: Option[AttachmentId] = None,
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    segmentName: Option[ConstrainedString] = None,
    edgeLocation: Option[ExternalRegionCode] = None,
    resourceType: Option[ConstrainedString] = None,
    resourceId: Option[ConstrainedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkRouteDestination = {
    import NetworkRouteDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkRouteDestination
      .builder()
      .optionallyWith(
        coreNetworkAttachmentId.map(value =>
          AttachmentId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkAttachmentId)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        segmentName.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly =
    zio.aws.networkmanager.model.NetworkRouteDestination.wrap(buildAwsValue())
}
object NetworkRouteDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkRouteDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkRouteDestination =
      zio.aws.networkmanager.model.NetworkRouteDestination(
        coreNetworkAttachmentId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        segmentName.map(value => value),
        edgeLocation.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value)
      )
    def coreNetworkAttachmentId: Option[AttachmentId]
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def segmentName: Option[ConstrainedString]
    def edgeLocation: Option[ExternalRegionCode]
    def resourceType: Option[ConstrainedString]
    def resourceId: Option[ConstrainedString]
    def getCoreNetworkAttachmentId: ZIO[Any, AwsError, AttachmentId] = AwsError
      .unwrapOptionField("coreNetworkAttachmentId", coreNetworkAttachmentId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getSegmentName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkRouteDestination
  ) extends zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly {
    override val coreNetworkAttachmentId: Option[AttachmentId] = scala
      .Option(impl.coreNetworkAttachmentId())
      .map(value => zio.aws.networkmanager.model.primitives.AttachmentId(value))
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayAttachmentId(value)
      )
    override val segmentName: Option[ConstrainedString] = scala
      .Option(impl.segmentName())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val edgeLocation: Option[ExternalRegionCode] = scala
      .Option(impl.edgeLocation())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val resourceType: Option[ConstrainedString] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceId: Option[ConstrainedString] = scala
      .Option(impl.resourceId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkRouteDestination
  ): zio.aws.networkmanager.model.NetworkRouteDestination.ReadOnly =
    new Wrapper(impl)
}
