package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  AWSAccountId,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkTelemetry(
    registeredGatewayArn: Option[ResourceArn] = None,
    coreNetworkId: Option[CoreNetworkId] = None,
    awsRegion: Option[ExternalRegionCode] = None,
    accountId: Option[AWSAccountId] = None,
    resourceType: Option[ConstrainedString] = None,
    resourceId: Option[ConstrainedString] = None,
    resourceArn: Option[ResourceArn] = None,
    address: Option[ConstrainedString] = None,
    health: Option[zio.aws.networkmanager.model.ConnectionHealth] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry = {
    import NetworkTelemetry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
      .builder()
      .optionallyWith(
        registeredGatewayArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.registeredGatewayArn)
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        awsRegion.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.awsRegion)
      .optionallyWith(
        accountId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        address.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(health.map(value => value.buildAwsValue()))(_.health)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly =
    zio.aws.networkmanager.model.NetworkTelemetry.wrap(buildAwsValue())
}
object NetworkTelemetry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkTelemetry =
      zio.aws.networkmanager.model.NetworkTelemetry(
        registeredGatewayArn.map(value => value),
        coreNetworkId.map(value => value),
        awsRegion.map(value => value),
        accountId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceArn.map(value => value),
        address.map(value => value),
        health.map(value => value.asEditable)
      )
    def registeredGatewayArn: Option[ResourceArn]
    def coreNetworkId: Option[CoreNetworkId]
    def awsRegion: Option[ExternalRegionCode]
    def accountId: Option[AWSAccountId]
    def resourceType: Option[ConstrainedString]
    def resourceId: Option[ConstrainedString]
    def resourceArn: Option[ResourceArn]
    def address: Option[ConstrainedString]
    def health: Option[zio.aws.networkmanager.model.ConnectionHealth.ReadOnly]
    def getRegisteredGatewayArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("registeredGatewayArn", registeredGatewayArn)
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getAwsRegion: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getAddress: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("address", address)
    def getHealth: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectionHealth.ReadOnly
    ] = AwsError.unwrapOptionField("health", health)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
  ) extends zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly {
    override val registeredGatewayArn: Option[ResourceArn] = scala
      .Option(impl.registeredGatewayArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val awsRegion: Option[ExternalRegionCode] = scala
      .Option(impl.awsRegion())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val accountId: Option[AWSAccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val resourceType: Option[ConstrainedString] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceId: Option[ConstrainedString] = scala
      .Option(impl.resourceId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val address: Option[ConstrainedString] = scala
      .Option(impl.address())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val health
        : Option[zio.aws.networkmanager.model.ConnectionHealth.ReadOnly] = scala
      .Option(impl.health())
      .map(value => zio.aws.networkmanager.model.ConnectionHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
  ): zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly = new Wrapper(impl)
}
