package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  DateTime,
  AWSAccountId,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NetworkResource(
    registeredGatewayArn: Option[ResourceArn] = None,
    coreNetworkId: Option[CoreNetworkId] = None,
    awsRegion: Option[ExternalRegionCode] = None,
    accountId: Option[AWSAccountId] = None,
    resourceType: Option[ConstrainedString] = None,
    resourceId: Option[ConstrainedString] = None,
    resourceArn: Option[ResourceArn] = None,
    definition: Option[ConstrainedString] = None,
    definitionTimestamp: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None,
    metadata: Option[Map[ConstrainedString, ConstrainedString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkResource = {
    import NetworkResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkResource
      .builder()
      .optionallyWith(
        registeredGatewayArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.registeredGatewayArn)
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        awsRegion.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.awsRegion)
      .optionallyWith(
        accountId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        definition.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.definition)
      .optionallyWith(
        definitionTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.definitionTimestamp)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (ConstrainedString
                .unwrap(key): java.lang.String) -> (ConstrainedString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkResource.ReadOnly =
    zio.aws.networkmanager.model.NetworkResource.wrap(buildAwsValue())
}
object NetworkResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkResource =
      zio.aws.networkmanager.model.NetworkResource(
        registeredGatewayArn.map(value => value),
        coreNetworkId.map(value => value),
        awsRegion.map(value => value),
        accountId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceArn.map(value => value),
        definition.map(value => value),
        definitionTimestamp.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metadata.map(value => value)
      )
    def registeredGatewayArn: Option[ResourceArn]
    def coreNetworkId: Option[CoreNetworkId]
    def awsRegion: Option[ExternalRegionCode]
    def accountId: Option[AWSAccountId]
    def resourceType: Option[ConstrainedString]
    def resourceId: Option[ConstrainedString]
    def resourceArn: Option[ResourceArn]
    def definition: Option[ConstrainedString]
    def definitionTimestamp: Option[DateTime]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def metadata: Option[Map[ConstrainedString, ConstrainedString]]
    def getRegisteredGatewayArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("registeredGatewayArn", registeredGatewayArn)
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getAwsRegion: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getDefinition: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("definition", definition)
    def getDefinitionTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("definitionTimestamp", definitionTimestamp)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMetadata
        : ZIO[Any, AwsError, Map[ConstrainedString, ConstrainedString]] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResource
  ) extends zio.aws.networkmanager.model.NetworkResource.ReadOnly {
    override val registeredGatewayArn: Option[ResourceArn] = scala
      .Option(impl.registeredGatewayArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val awsRegion: Option[ExternalRegionCode] = scala
      .Option(impl.awsRegion())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val accountId: Option[AWSAccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val resourceType: Option[ConstrainedString] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceId: Option[ConstrainedString] = scala
      .Option(impl.resourceId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val definition: Option[ConstrainedString] = scala
      .Option(impl.definition())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val definitionTimestamp: Option[DateTime] = scala
      .Option(impl.definitionTimestamp())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val metadata: Option[Map[ConstrainedString, ConstrainedString]] =
      scala
        .Option(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.networkmanager.model.primitives.ConstrainedString(
                key
              ) -> zio.aws.networkmanager.model.primitives
                .ConstrainedString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResource
  ): zio.aws.networkmanager.model.NetworkResource.ReadOnly = new Wrapper(impl)
}
