package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateVpcAttachmentResponse(
    vpcAttachment: Option[zio.aws.networkmanager.model.VpcAttachment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse = {
    import UpdateVpcAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
      .builder()
      .optionallyWith(vpcAttachment.map(value => value.buildAwsValue()))(
        _.vpcAttachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateVpcAttachmentResponse
      .wrap(buildAwsValue())
}
object UpdateVpcAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateVpcAttachmentResponse =
      zio.aws.networkmanager.model.UpdateVpcAttachmentResponse(
        vpcAttachment.map(value => value.asEditable)
      )
    def vpcAttachment
        : Option[zio.aws.networkmanager.model.VpcAttachment.ReadOnly]
    def getVpcAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.VpcAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("vpcAttachment", vpcAttachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
  ) extends zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly {
    override val vpcAttachment
        : Option[zio.aws.networkmanager.model.VpcAttachment.ReadOnly] = scala
      .Option(impl.vpcAttachment())
      .map(value => zio.aws.networkmanager.model.VpcAttachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateVpcAttachmentResponse
  ): zio.aws.networkmanager.model.UpdateVpcAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
