package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{ConstrainedString, IPAddress}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConnectPeerConfiguration(
    coreNetworkAddress: Option[IPAddress] = None,
    peerAddress: Option[IPAddress] = None,
    insideCidrBlocks: Option[Iterable[ConstrainedString]] = None,
    protocol: Option[zio.aws.networkmanager.model.TunnelProtocol] = None,
    bgpConfigurations: Option[
      Iterable[zio.aws.networkmanager.model.ConnectPeerBgpConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectPeerConfiguration = {
    import ConnectPeerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerConfiguration
      .builder()
      .optionallyWith(
        coreNetworkAddress.map(value =>
          IPAddress.unwrap(value): java.lang.String
        )
      )(_.coreNetworkAddress)
      .optionallyWith(
        peerAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.peerAddress)
      .optionallyWith(
        insideCidrBlocks.map(value =>
          value.map { item =>
            ConstrainedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insideCidrBlocks)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        bgpConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bgpConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ConnectPeerConfiguration.ReadOnly =
    zio.aws.networkmanager.model.ConnectPeerConfiguration.wrap(buildAwsValue())
}
object ConnectPeerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectPeerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectPeerConfiguration =
      zio.aws.networkmanager.model.ConnectPeerConfiguration(
        coreNetworkAddress.map(value => value),
        peerAddress.map(value => value),
        insideCidrBlocks.map(value => value),
        protocol.map(value => value),
        bgpConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def coreNetworkAddress: Option[IPAddress]
    def peerAddress: Option[IPAddress]
    def insideCidrBlocks: Option[List[ConstrainedString]]
    def protocol: Option[zio.aws.networkmanager.model.TunnelProtocol]
    def bgpConfigurations: Option[
      List[zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly]
    ]
    def getCoreNetworkAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("coreNetworkAddress", coreNetworkAddress)
    def getPeerAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("peerAddress", peerAddress)
    def getInsideCidrBlocks: ZIO[Any, AwsError, List[ConstrainedString]] =
      AwsError.unwrapOptionField("insideCidrBlocks", insideCidrBlocks)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.TunnelProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getBgpConfigurations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("bgpConfigurations", bgpConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerConfiguration
  ) extends zio.aws.networkmanager.model.ConnectPeerConfiguration.ReadOnly {
    override val coreNetworkAddress: Option[IPAddress] = scala
      .Option(impl.coreNetworkAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
    override val peerAddress: Option[IPAddress] = scala
      .Option(impl.peerAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
    override val insideCidrBlocks: Option[List[ConstrainedString]] = scala
      .Option(impl.insideCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(item)
        }.toList
      )
    override val protocol: Option[zio.aws.networkmanager.model.TunnelProtocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.networkmanager.model.TunnelProtocol.wrap(value))
    override val bgpConfigurations: Option[
      List[zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.ReadOnly]
    ] = scala
      .Option(impl.bgpConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.ConnectPeerBgpConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectPeerConfiguration
  ): zio.aws.networkmanager.model.ConnectPeerConfiguration.ReadOnly =
    new Wrapper(impl)
}
