package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateGlobalNetworkRequest(
    globalNetworkId: GlobalNetworkId,
    description: Option[ConstrainedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest = {
    import UpdateGlobalNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateGlobalNetworkRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateGlobalNetworkRequest
      .wrap(buildAwsValue())
}
object UpdateGlobalNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateGlobalNetworkRequest =
      zio.aws.networkmanager.model.UpdateGlobalNetworkRequest(
        globalNetworkId,
        description.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def description: Option[ConstrainedString]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest
  ) extends zio.aws.networkmanager.model.UpdateGlobalNetworkRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateGlobalNetworkRequest
  ): zio.aws.networkmanager.model.UpdateGlobalNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
