package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId,
  TransitGatewayConnectPeerArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnectPeerAssociation(
    transitGatewayConnectPeerArn: Option[TransitGatewayConnectPeerArn] = None,
    globalNetworkId: Option[GlobalNetworkId] = None,
    deviceId: Option[DeviceId] = None,
    linkId: Option[LinkId] = None,
    state: Option[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociation = {
    import TransitGatewayConnectPeerAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociation
      .builder()
      .optionallyWith(
        transitGatewayConnectPeerArn.map(value =>
          TransitGatewayConnectPeerArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayConnectPeerArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly =
    zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
      .wrap(buildAwsValue())
}
object TransitGatewayConnectPeerAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation =
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation(
        transitGatewayConnectPeerArn.map(value => value),
        globalNetworkId.map(value => value),
        deviceId.map(value => value),
        linkId.map(value => value),
        state.map(value => value)
      )
    def transitGatewayConnectPeerArn: Option[TransitGatewayConnectPeerArn]
    def globalNetworkId: Option[GlobalNetworkId]
    def deviceId: Option[DeviceId]
    def linkId: Option[LinkId]
    def state: Option[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState
    ]
    def getTransitGatewayConnectPeerArn
        : ZIO[Any, AwsError, TransitGatewayConnectPeerArn] =
      AwsError.unwrapOptionField(
        "transitGatewayConnectPeerArn",
        transitGatewayConnectPeerArn
      )
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociation
  ) extends zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly {
    override val transitGatewayConnectPeerArn
        : Option[TransitGatewayConnectPeerArn] = scala
      .Option(impl.transitGatewayConnectPeerArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayConnectPeerArn(value)
      )
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val deviceId: Option[DeviceId] = scala
      .Option(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val linkId: Option[LinkId] = scala
      .Option(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val state: Option[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState
    ] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociationState
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociation
  ): zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly =
    new Wrapper(impl)
}
