package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateLinkResponse(
    linkAssociation: Option[zio.aws.networkmanager.model.LinkAssociation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse = {
    import AssociateLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse
      .builder()
      .optionallyWith(linkAssociation.map(value => value.buildAwsValue()))(
        _.linkAssociation
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly =
    zio.aws.networkmanager.model.AssociateLinkResponse.wrap(buildAwsValue())
}
object AssociateLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AssociateLinkResponse =
      zio.aws.networkmanager.model
        .AssociateLinkResponse(linkAssociation.map(value => value.asEditable))
    def linkAssociation
        : Option[zio.aws.networkmanager.model.LinkAssociation.ReadOnly]
    def getLinkAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.LinkAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("linkAssociation", linkAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse
  ) extends zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly {
    override val linkAssociation
        : Option[zio.aws.networkmanager.model.LinkAssociation.ReadOnly] = scala
      .Option(impl.linkAssociation())
      .map(value => zio.aws.networkmanager.model.LinkAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateLinkResponse
  ): zio.aws.networkmanager.model.AssociateLinkResponse.ReadOnly = new Wrapper(
    impl
  )
}
