package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateConnectionResponse(
    connection: Option[zio.aws.networkmanager.model.Connection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse = {
    import UpdateConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateConnectionResponse.wrap(buildAwsValue())
}
object UpdateConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateConnectionResponse =
      zio.aws.networkmanager.model
        .UpdateConnectionResponse(connection.map(value => value.asEditable))
    def connection: Option[zio.aws.networkmanager.model.Connection.ReadOnly]
    def getConnection
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Connection.ReadOnly] =
      AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
  ) extends zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly {
    override val connection
        : Option[zio.aws.networkmanager.model.Connection.ReadOnly] = scala
      .Option(impl.connection())
      .map(value => zio.aws.networkmanager.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateConnectionResponse
  ): zio.aws.networkmanager.model.UpdateConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
