package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetConnectPeerResponse(
    connectPeer: Option[zio.aws.networkmanager.model.ConnectPeer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectPeerResponse = {
    import GetConnectPeerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerResponse
      .builder()
      .optionallyWith(connectPeer.map(value => value.buildAwsValue()))(
        _.connectPeer
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly =
    zio.aws.networkmanager.model.GetConnectPeerResponse.wrap(buildAwsValue())
}
object GetConnectPeerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetConnectPeerResponse =
      zio.aws.networkmanager.model
        .GetConnectPeerResponse(connectPeer.map(value => value.asEditable))
    def connectPeer: Option[zio.aws.networkmanager.model.ConnectPeer.ReadOnly]
    def getConnectPeer: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeer.ReadOnly
    ] = AwsError.unwrapOptionField("connectPeer", connectPeer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerResponse
  ) extends zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly {
    override val connectPeer
        : Option[zio.aws.networkmanager.model.ConnectPeer.ReadOnly] = scala
      .Option(impl.connectPeer())
      .map(value => zio.aws.networkmanager.model.ConnectPeer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerResponse
  ): zio.aws.networkmanager.model.GetConnectPeerResponse.ReadOnly = new Wrapper(
    impl
  )
}
