package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteCoreNetworkResponse(
    coreNetwork: Option[zio.aws.networkmanager.model.CoreNetwork] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkResponse = {
    import DeleteCoreNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkResponse
      .builder()
      .optionallyWith(coreNetwork.map(value => value.buildAwsValue()))(
        _.coreNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteCoreNetworkResponse.wrap(buildAwsValue())
}
object DeleteCoreNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteCoreNetworkResponse =
      zio.aws.networkmanager.model
        .DeleteCoreNetworkResponse(coreNetwork.map(value => value.asEditable))
    def coreNetwork: Option[zio.aws.networkmanager.model.CoreNetwork.ReadOnly]
    def getCoreNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("coreNetwork", coreNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkResponse
  ) extends zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly {
    override val coreNetwork
        : Option[zio.aws.networkmanager.model.CoreNetwork.ReadOnly] = scala
      .Option(impl.coreNetwork())
      .map(value => zio.aws.networkmanager.model.CoreNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkResponse
  ): zio.aws.networkmanager.model.DeleteCoreNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
