package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BgpOptions(peerAsn: Option[Long] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.BgpOptions = {
    import BgpOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.BgpOptions
      .builder()
      .optionallyWith(peerAsn.map(value => value: java.lang.Long))(_.peerAsn)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.BgpOptions.ReadOnly =
    zio.aws.networkmanager.model.BgpOptions.wrap(buildAwsValue())
}
object BgpOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.BgpOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.BgpOptions =
      zio.aws.networkmanager.model.BgpOptions(peerAsn.map(value => value))
    def peerAsn: Option[Long]
    def getPeerAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("peerAsn", peerAsn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.BgpOptions
  ) extends zio.aws.networkmanager.model.BgpOptions.ReadOnly {
    override val peerAsn: Option[Long] =
      scala.Option(impl.peerAsn()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.BgpOptions
  ): zio.aws.networkmanager.model.BgpOptions.ReadOnly = new Wrapper(impl)
}
