package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  SiteId,
  ConstrainedString,
  DeviceId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDeviceRequest(
    globalNetworkId: GlobalNetworkId,
    deviceId: DeviceId,
    awsLocation: Option[zio.aws.networkmanager.model.AWSLocation] = None,
    description: Option[ConstrainedString] = None,
    `type`: Option[ConstrainedString] = None,
    vendor: Option[ConstrainedString] = None,
    model: Option[ConstrainedString] = None,
    serialNumber: Option[ConstrainedString] = None,
    location: Option[zio.aws.networkmanager.model.Location] = None,
    siteId: Option[SiteId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest = {
    import UpdateDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .optionallyWith(awsLocation.map(value => value.buildAwsValue()))(
        _.awsLocation
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vendor.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        model.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        serialNumber.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.UpdateDeviceRequest.ReadOnly =
    zio.aws.networkmanager.model.UpdateDeviceRequest.wrap(buildAwsValue())
}
object UpdateDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateDeviceRequest =
      zio.aws.networkmanager.model.UpdateDeviceRequest(
        globalNetworkId,
        deviceId,
        awsLocation.map(value => value.asEditable),
        description.map(value => value),
        `type`.map(value => value),
        vendor.map(value => value),
        model.map(value => value),
        serialNumber.map(value => value),
        location.map(value => value.asEditable),
        siteId.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def deviceId: DeviceId
    def awsLocation: Option[zio.aws.networkmanager.model.AWSLocation.ReadOnly]
    def description: Option[ConstrainedString]
    def `type`: Option[ConstrainedString]
    def vendor: Option[ConstrainedString]
    def model: Option[ConstrainedString]
    def serialNumber: Option[ConstrainedString]
    def location: Option[zio.aws.networkmanager.model.Location.ReadOnly]
    def siteId: Option[SiteId]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
    def getAwsLocation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.AWSLocation.ReadOnly
    ] = AwsError.unwrapOptionField("awsLocation", awsLocation)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVendor: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getModel: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("model", model)
    def getSerialNumber: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest
  ) extends zio.aws.networkmanager.model.UpdateDeviceRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val deviceId: DeviceId =
      zio.aws.networkmanager.model.primitives.DeviceId(impl.deviceId())
    override val awsLocation
        : Option[zio.aws.networkmanager.model.AWSLocation.ReadOnly] = scala
      .Option(impl.awsLocation())
      .map(value => zio.aws.networkmanager.model.AWSLocation.wrap(value))
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val `type`: Option[ConstrainedString] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val vendor: Option[ConstrainedString] = scala
      .Option(impl.vendor())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val model: Option[ConstrainedString] = scala
      .Option(impl.model())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val serialNumber: Option[ConstrainedString] = scala
      .Option(impl.serialNumber())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val location
        : Option[zio.aws.networkmanager.model.Location.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val siteId: Option[SiteId] = scala
      .Option(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateDeviceRequest
  ): zio.aws.networkmanager.model.UpdateDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
