package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{ConstrainedString, ResourceArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkResourceSummary(
    registeredGatewayArn: Option[ResourceArn] = None,
    resourceArn: Option[ResourceArn] = None,
    resourceType: Option[ConstrainedString] = None,
    definition: Option[ConstrainedString] = None,
    nameTag: Option[ConstrainedString] = None,
    isMiddlebox: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkResourceSummary = {
    import NetworkResourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkResourceSummary
      .builder()
      .optionallyWith(
        registeredGatewayArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.registeredGatewayArn)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        definition.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.definition)
      .optionallyWith(
        nameTag.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.nameTag)
      .optionallyWith(isMiddlebox.map(value => value: java.lang.Boolean))(
        _.isMiddlebox
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkResourceSummary.ReadOnly =
    zio.aws.networkmanager.model.NetworkResourceSummary.wrap(buildAwsValue())
}
object NetworkResourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkResourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkResourceSummary =
      zio.aws.networkmanager.model.NetworkResourceSummary(
        registeredGatewayArn.map(value => value),
        resourceArn.map(value => value),
        resourceType.map(value => value),
        definition.map(value => value),
        nameTag.map(value => value),
        isMiddlebox.map(value => value)
      )
    def registeredGatewayArn: Option[ResourceArn]
    def resourceArn: Option[ResourceArn]
    def resourceType: Option[ConstrainedString]
    def definition: Option[ConstrainedString]
    def nameTag: Option[ConstrainedString]
    def isMiddlebox: Option[Boolean]
    def getRegisteredGatewayArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("registeredGatewayArn", registeredGatewayArn)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getDefinition: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("definition", definition)
    def getNameTag: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("nameTag", nameTag)
    def getIsMiddlebox: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMiddlebox", isMiddlebox)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResourceSummary
  ) extends zio.aws.networkmanager.model.NetworkResourceSummary.ReadOnly {
    override val registeredGatewayArn: Option[ResourceArn] = scala
      .Option(impl.registeredGatewayArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val resourceType: Option[ConstrainedString] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val definition: Option[ConstrainedString] = scala
      .Option(impl.definition())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val nameTag: Option[ConstrainedString] = scala
      .Option(impl.nameTag())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val isMiddlebox: Option[Boolean] =
      scala.Option(impl.isMiddlebox()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResourceSummary
  ): zio.aws.networkmanager.model.NetworkResourceSummary.ReadOnly = new Wrapper(
    impl
  )
}
