package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  SiteId,
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLinkRequest(
    globalNetworkId: GlobalNetworkId,
    description: Option[ConstrainedString] = None,
    `type`: Option[ConstrainedString] = None,
    bandwidth: zio.aws.networkmanager.model.Bandwidth,
    provider: Option[ConstrainedString] = None,
    siteId: SiteId,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest = {
    import CreateLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .bandwidth(bandwidth.buildAwsValue())
      .optionallyWith(
        provider.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.provider)
      .siteId(SiteId.unwrap(siteId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CreateLinkRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateLinkRequest.wrap(buildAwsValue())
}
object CreateLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateLinkRequest =
      zio.aws.networkmanager.model.CreateLinkRequest(
        globalNetworkId,
        description.map(value => value),
        `type`.map(value => value),
        bandwidth.asEditable,
        provider.map(value => value),
        siteId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: GlobalNetworkId
    def description: Option[ConstrainedString]
    def `type`: Option[ConstrainedString]
    def bandwidth: zio.aws.networkmanager.model.Bandwidth.ReadOnly
    def provider: Option[ConstrainedString]
    def siteId: SiteId
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getBandwidth
        : ZIO[Any, Nothing, zio.aws.networkmanager.model.Bandwidth.ReadOnly] =
      ZIO.succeed(bandwidth)
    def getProvider: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("provider", provider)
    def getSiteId: ZIO[Any, Nothing, SiteId] = ZIO.succeed(siteId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest
  ) extends zio.aws.networkmanager.model.CreateLinkRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val `type`: Option[ConstrainedString] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val bandwidth: zio.aws.networkmanager.model.Bandwidth.ReadOnly =
      zio.aws.networkmanager.model.Bandwidth.wrap(impl.bandwidth())
    override val provider: Option[ConstrainedString] = scala
      .Option(impl.provider())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val siteId: SiteId =
      zio.aws.networkmanager.model.primitives.SiteId(impl.siteId())
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateLinkRequest
  ): zio.aws.networkmanager.model.CreateLinkRequest.ReadOnly = new Wrapper(impl)
}
