package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  SiteId,
  ConstrainedString,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDeviceRequest(
    globalNetworkId: GlobalNetworkId,
    awsLocation: Option[zio.aws.networkmanager.model.AWSLocation] = None,
    description: Option[ConstrainedString] = None,
    `type`: Option[ConstrainedString] = None,
    vendor: Option[ConstrainedString] = None,
    model: Option[ConstrainedString] = None,
    serialNumber: Option[ConstrainedString] = None,
    location: Option[zio.aws.networkmanager.model.Location] = None,
    siteId: Option[SiteId] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest = {
    import CreateDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(awsLocation.map(value => value.buildAwsValue()))(
        _.awsLocation
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vendor.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        model.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        serialNumber.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CreateDeviceRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateDeviceRequest.wrap(buildAwsValue())
}
object CreateDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateDeviceRequest =
      zio.aws.networkmanager.model.CreateDeviceRequest(
        globalNetworkId,
        awsLocation.map(value => value.asEditable),
        description.map(value => value),
        `type`.map(value => value),
        vendor.map(value => value),
        model.map(value => value),
        serialNumber.map(value => value),
        location.map(value => value.asEditable),
        siteId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: GlobalNetworkId
    def awsLocation: Option[zio.aws.networkmanager.model.AWSLocation.ReadOnly]
    def description: Option[ConstrainedString]
    def `type`: Option[ConstrainedString]
    def vendor: Option[ConstrainedString]
    def model: Option[ConstrainedString]
    def serialNumber: Option[ConstrainedString]
    def location: Option[zio.aws.networkmanager.model.Location.ReadOnly]
    def siteId: Option[SiteId]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getAwsLocation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.AWSLocation.ReadOnly
    ] = AwsError.unwrapOptionField("awsLocation", awsLocation)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVendor: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getModel: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("model", model)
    def getSerialNumber: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
  ) extends zio.aws.networkmanager.model.CreateDeviceRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val awsLocation
        : Option[zio.aws.networkmanager.model.AWSLocation.ReadOnly] = scala
      .Option(impl.awsLocation())
      .map(value => zio.aws.networkmanager.model.AWSLocation.wrap(value))
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val `type`: Option[ConstrainedString] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val vendor: Option[ConstrainedString] = scala
      .Option(impl.vendor())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val model: Option[ConstrainedString] = scala
      .Option(impl.model())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val serialNumber: Option[ConstrainedString] = scala
      .Option(impl.serialNumber())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val location
        : Option[zio.aws.networkmanager.model.Location.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val siteId: Option[SiteId] = scala
      .Option(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateDeviceRequest
  ): zio.aws.networkmanager.model.CreateDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
