package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.DateTime
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ConnectionHealth(
    `type`: Option[zio.aws.networkmanager.model.ConnectionType] = None,
    status: Option[zio.aws.networkmanager.model.ConnectionStatus] = None,
    timestamp: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectionHealth = {
    import ConnectionHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectionHealth
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ConnectionHealth.ReadOnly =
    zio.aws.networkmanager.model.ConnectionHealth.wrap(buildAwsValue())
}
object ConnectionHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectionHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectionHealth =
      zio.aws.networkmanager.model.ConnectionHealth(
        `type`.map(value => value),
        status.map(value => value),
        timestamp.map(value => value)
      )
    def `type`: Option[zio.aws.networkmanager.model.ConnectionType]
    def status: Option[zio.aws.networkmanager.model.ConnectionStatus]
    def timestamp: Option[DateTime]
    def getType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ConnectionType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ConnectionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectionHealth
  ) extends zio.aws.networkmanager.model.ConnectionHealth.ReadOnly {
    override val `type`: Option[zio.aws.networkmanager.model.ConnectionType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.networkmanager.model.ConnectionType.wrap(value))
    override val status: Option[zio.aws.networkmanager.model.ConnectionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.networkmanager.model.ConnectionStatus.wrap(value))
    override val timestamp: Option[DateTime] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectionHealth
  ): zio.aws.networkmanager.model.ConnectionHealth.ReadOnly = new Wrapper(impl)
}
